IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CPJ_Cbtes_Aplic_Automat_Cli_RcVSFC') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CPJ_Cbtes_Aplic_Automat_Cli_RcVSFC
END
GO

CREATE PROCEDURE dbo.CPJ_Cbtes_Aplic_Automat_Cli_RcVSFC @pJson VARCHAR(8000)
AS
SET NOCOUNT ON

/*Variables recibidas por parametro a traves del JSON*/
DECLARE @pFlagUsarTrans				TINYINT
DECLARE @pModoDebug					TINYINT
DECLARE @pId_Usuario				SMALLINT
DECLARE @pId_Tipo_Cbte_Rec_A_Cta	CHAR(4)
DECLARE @pFecha						DATETIME
DECLARE @pId_Tipo_Cbte_Fac_Pend		CHAR(4)
DECLARE @pId_Tipo_Cbte_Rec_Nuevo	CHAR(4)
DECLARE @pId_Periodo_Caja			INT
DECLARE @pLote						VARCHAR(20)
DECLARE @pLote_Descrip				VARCHAR(50)
DECLARE @pId_Lote_Tipo				SMALLINT
DECLARE @pId_Producto_Devolucion	VARCHAR(14)
DECLARE @pId_Moneda					CHAR(3)
DECLARE @pCotizacion				DECIMAL(12,4)
DECLARE @pProvisorio				TINYINT

SET @pFlagUsarTrans				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Usuario				= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Usuario')), 0)
SET @pId_Tipo_Cbte_Rec_A_Cta	= ISNULL(CONVERT(CHAR(4), dbo.CF_JSON_VALUE(@pJson,'Id_Tipo_Cbte_Rec_A_Cta')), '')
SET @pFecha						= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha')), '19000101')
SET @pId_Tipo_Cbte_Fac_Pend		= ISNULL(CONVERT(CHAR(4), dbo.CF_JSON_VALUE(@pJson,'Id_Tipo_Cbte_Fac_Pend')), '')
SET @pId_Tipo_Cbte_Rec_Nuevo	= ISNULL(CONVERT(CHAR(4), dbo.CF_JSON_VALUE(@pJson,'Id_Tipo_Cbte_Rec_Nuevo')), '')
SET @pId_Periodo_Caja			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Periodo_Caja')), 0)
SET @pLote						= ISNULL(CONVERT(VARCHAR(20), dbo.CF_JSON_VALUE(@pJson,'Lote')), '')
SET @pLote_Descrip				= ISNULL(CONVERT(VARCHAR(50), dbo.CF_JSON_VALUE(@pJson,'Lote_Descrip')), '')
SET @pId_Lote_Tipo				= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Lote_Tipo')), 0)
SET @pId_Producto_Devolucion	= ISNULL(CONVERT(VARCHAR(14), dbo.CF_JSON_VALUE(@pJson,'Id_Producto_Devolucion')), '')
SET @pId_Moneda					= ISNULL(CONVERT(CHAR(3), dbo.CF_JSON_VALUE(@pJson,'Id_Moneda')), '')
SET @pCotizacion				= ISNULL(CONVERT(DECIMAL(12,4), dbo.CF_JSON_VALUE(@pJson,'Cotizacion')), 0)
SET @pProvisorio				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Provisorio')), 0)
/*FIN Variables recibidas por parametro a traves del JSON*/

/*Declaraciones Variables Locales*/
DECLARE @rtaMsjStored				VARCHAR(4000)

DECLARE @JSON_Parametros			VARCHAR(8000)
DECLARE @Respuesta TABLE (	ErrorNumber		INT,
							ErrorSeverity	INT,
							ErrorState		INT,
							ErrorProcedure  VARCHAR(1000),
							ErrorLine		INT,
							ErrorMessage	VARCHAR(1000))
DECLARE @UltError					INT

DECLARE @Cli_Ref_CtaCte_Agrup		INT
DECLARE @ErrorNumber				INT
DECLARE @Id_Cliente					INT
DECLARE @Id_Trans_Rec				INT
DECLARE	@Saldo_Rec					DECIMAL(12,2)
DECLARE @Id_Trans_Fac				INT
DECLARE @Saldo_Fac					DECIMAL(12,2)
DECLARE @Importe					DECIMAL(12,2)
DECLARE @Id_Trans_Rec_Nuevo			INT
DECLARE @Email_Cob					VARCHAR(256)
DECLARE @Saldo_Rec_A_Grabar			DECIMAL(12,2)
/*Fin de Declaraciones Variables Locales*/

/*Declaracion Tablas Auxiliares*/
IF OBJECT_ID('tempdb..#Tab_Result') IS NOT NULL
BEGIN
	DROP TABLE #Tab_Result
END

CREATE TABLE #Tab_Result 
(
Id_Cliente				INT,
Id_Trans_Rec			INT,
Saldo_Rec				DECIMAL(16,2),
Id_Trans_Fac			INT,
Saldo_Fac				DECIMAL(16,2),
Importe_Aplic			DECIMAL(16,2)
)

CREATE INDEX IX_Tab_Result ON #Tab_Result (Id_Trans_Rec, Id_Trans_Fac)

-----------------------------------------------------------------------

IF OBJECT_ID('tempdb..#Recibos_Pendientes') IS NOT NULL
BEGIN
	DROP TABLE #Recibos_Pendientes
END

CREATE TABLE #Recibos_Pendientes 
(
Id_Cliente				INT,
Id_Trans				INT,
Saldo					DECIMAL(16,2),
Id_Cliente_Tit			INT
)

CREATE INDEX IX_Recibos_Pendientes_Aux ON #Recibos_Pendientes (Id_Cliente_Tit, Id_Trans)

-----------------------------------------------------------------------

IF OBJECT_ID('tempdb..#Fac_Cli') IS NOT NULL
BEGIN
	DROP TABLE #Fac_Cli
END

CREATE TABLE #Fac_Cli 
(
Id_Cliente				INT
)

-----------------------------------------------------------------------

IF OBJECT_ID('tempdb..#Facturas_Pendientes') IS NOT NULL
BEGIN
	DROP TABLE #Facturas_Pendientes
END

CREATE TABLE #Facturas_Pendientes
(
Id_Cliente				INT,
Id_Trans				INT,
Saldo					DECIMAL(16,2),
Id_Cliente_Tit			INT
)
/*FIN Declaracion Tablas Auxiliares*/

BEGIN TRY

	IF ISNULL(@pFlagUsarTrans,0) <> 0
	BEGIN
		BEGIN TRAN
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Cbtes_Aplic_Automat_Cli_RcVSFC'
		PRINT 'Parametros:'
		PRINT '@pFlagUsarTrans: ' + CONVERT(VARCHAR(10), @pFlagUsarTrans) + '. @pId_Usuario: ' + CONVERT(VARCHAR(10), @pId_Usuario)
		PRINT '@pId_Tipo_Cbte_Rec_A_Cta: ' + @pId_Tipo_Cbte_Rec_A_Cta + ' @pFecha: ' + CONVERT(VARCHAR(10), @pFecha, 102) + ' @pId_Tipo_Cbte_Fac_Pend: ' + @pId_Tipo_Cbte_Fac_Pend + ' @pId_Tipo_Cbte_Rec_Nuevo: ' + @pId_Tipo_Cbte_Rec_Nuevo + ' @pId_Periodo_Caja: ' + CONVERT(VARCHAR(10), @pId_Periodo_Caja) + ' @pLote: ' + @pLote + ' @pLote_Descrip: ' + @pLote_Descrip + ' @pId_Lote_Tipo: ' + CONVERT(VARCHAR(10), @pId_Lote_Tipo) + ' @pId_Producto_Devolucion: ' + @pId_Producto_Devolucion + ' @pId_Moneda: ' + @pId_Moneda + ' @pCotizacion: ' + CONVERT(VARCHAR(10), @pCotizacion)
		PRINT ' '
	END

	/*Control Parametros*/
	IF(@pId_Usuario = 0)				RAISERROR ('Parameter Id_Usuario mandatory.', 16, 1)
	IF(@pId_Tipo_Cbte_Rec_A_Cta = '')	RAISERROR ('Parameter Id_Tipo_Cbte_Rec_A_Cta mandatory.', 16, 1)
	IF(@pFecha = '19000101')			RAISERROR ('Parameter pFecha mandatory.', 16, 1)
	IF(@pId_Tipo_Cbte_Fac_Pend = '')	RAISERROR ('Parameter Id_Tipo_Cbte_Fac_Pend mandatory.', 16, 1)
	IF(@pId_Tipo_Cbte_Rec_Nuevo = '')	RAISERROR ('Parameter Id_Tipo_Cbte_Rec_Nuevo mandatory.', 16, 1)
	IF(@pId_Periodo_Caja = 0)			RAISERROR ('Parameter Id_Periodo_Caja mandatory.', 16, 1)
	IF(@pLote = '')						RAISERROR ('Parameter Lote mandatory.', 16, 1)
	IF(@pLote_Descrip = '')				RAISERROR ('Parameter Lote_Descrip mandatory.', 16, 1)
	IF(@pId_Lote_Tipo = 0)				RAISERROR ('Parameter Id_Lote_Tipo mandatory.', 16, 1)
	IF(@pId_Producto_Devolucion = '')	RAISERROR ('Parameter Id_Producto_Devolucion mandatory.', 16, 1)
	IF(@pId_Moneda = '')				RAISERROR ('Parameter Id_Moneda mandatory.', 16, 1)
	IF(@pCotizacion = 0)				RAISERROR ('Parameter Cotizacion mandatory.', 16, 1)
	/*FIN Control Parametros*/

	/*-----------------------------------------------------------------------------------------------------------------------------------------------*/

	/*Cbtes_Lotes*/
	IF (ISNULL(@pProvisorio, 0) = 0)
	BEGIN
		IF EXISTS(SELECT 1 FROM Cbtes_Lotes WHERE Lote = @pLote)
		BEGIN
			RETURN 1
		END
		ELSE
		BEGIN
			IF(@pModoDebug = 1)
			BEGIN
				PRINT 'Inserta Cbtes_Lotes'
				PRINT ' '
			END

			INSERT INTO Cbtes_Lotes 
			(Lote,			Fecha,			Descripcion,	
			Id_Lote_Tipo,	Cantidad,		Importe,
			Observacion,	Id_Tipo_Con,	Flag_enProceso,
			Fecha_Inicio,	Fecha_Finalizacion)
			VALUES
			(@pLote,		@pFecha,		@pLote_Descrip,
			@pId_Lote_Tipo,	0,				0,
			'',				0,				0,
			GETDATE(),		GETDATE())
		END
	END

	/*-----------------------------------------------------------------------------------------------------------------------------------------------*/

	SET @Cli_Ref_CtaCte_Agrup = CONVERT(INT, dbo.CF_xParam('Cli_Ref_CtaCte_Agrup'))

	IF(@pModoDebug = 1)
	BEGIN
		PRINT '@Cli_Ref_CtaCte_Agrup: ' + CONVERT(VARCHAR(10), @Cli_Ref_CtaCte_Agrup)
	END

	/*-----------------------------------------------------------------------------------------------------------------------------------------------*/

	/*Se carga los Recibos a Cuenta en la tabla Auxiliar #Recibos_Pendientes*/
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Se carga los Recibos a Cuenta en la tabla Auxiliar #Recibos_Pendientes'
		PRINT ' '
	END

	INSERT INTO #Recibos_Pendientes
	(Id_Cliente, Id_Trans, Saldo, Id_Cliente_Tit)
	SELECT CB.Id_Cliente, CB.Id_Trans, CB.Saldo, NULL 
	FROM Cbtes CB, Cbtes_Tipos CT
	WHERE 
	CB.Id_Tipo_Cbte = CT.Id_Tipo_Cbte
	AND CT.Compromete_Recibos = 1
	AND CB.Id_Tipo_Cbte = @pId_Tipo_Cbte_Rec_A_Cta 
	AND CB.Id_Estado_Cbte IN (1/*Pendiente*/, 4/*Parcial*/)

	IF (@Cli_Ref_CtaCte_Agrup <> 0)
	BEGIN
		UPDATE #Recibos_Pendientes 
		SET 
		Id_Cliente_Tit = CL.Id_Cliente_Ref
		FROM #Recibos_Pendientes RC, Clientes CL
		WHERE 
		CL.Id_Cliente = RC.Id_Cliente
		AND ISNULL(CL.Id_Cliente_Ref,0) <> 0
	END

	UPDATE #Recibos_Pendientes 
	SET 
	Id_Cliente_Tit = Id_Cliente 
	WHERE 
	ISNULL(Id_Cliente_Tit, 0) = 0

	/*-----------------------------------------------------------------------------------------------------------------------------------------------*/

	/*Se identifica los clientes para cargar las facturas cargando en tabla Auxiliar #Fac_Cli*/
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Se identifica los clientes para cargar las facturas cargando en tabla Auxiliar #Fac_Cli'
	END

	INSERT INTO #Fac_Cli
	SELECT DISTINCT(Id_Cliente_Tit) FROM #Recibos_Pendientes

	--Agrego a la lista los integrantes del grupo
	IF (@Cli_Ref_CtaCte_Agrup <> 0)
	BEGIN
		IF(@pModoDebug = 1)
		BEGIN
			PRINT 'Agrego a la lista los integrantes del grupo'
		END

		INSERT INTO #Fac_Cli
		SELECT DISTINCT(C.Id_Cliente) 
		FROM Clientes C, #Recibos_Pendientes RC
		WHERE 
		C.Id_Cliente_Ref = RC.Id_Cliente_Tit
		AND NOT EXISTS (SELECT 1 FROM #Fac_Cli F WHERE C.id_Cliente = F.Id_Cliente)
	END

	/*-----------------------------------------------------------------------------------------------------------------------------------------------*/
	
	/*Ser carga la lista de facturas a cancelar en la tabla Auxiliar #Facturas_Pendientes*/
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Se carga la lista de facturas a cancelar en la tabla Auxiliar #Facturas_Pendientes'
		PRINT ' '
	END

	INSERT INTO #Facturas_Pendientes
	(Id_Cliente, Id_Trans, Saldo, Id_Cliente_Tit)
	SELECT CB.Id_Cliente, CB.Id_Trans, CB.Saldo, CL.Id_Cliente_Ref
	FROM Cbtes CB, Cbtes_Tipos CT, #Fac_Cli F, Clientes CL
	WHERE 
	CB.Id_Tipo_Cbte = CT.Id_Tipo_Cbte
	AND CB.Id_Cliente = F.Id_Cliente
	AND CL.Id_Cliente = F.Id_Cliente
	AND CT.Compromete_Factura = 1 
	AND CB.Id_Tipo_Cbte = @pId_Tipo_Cbte_Fac_Pend
	AND CB.Id_Estado_Cbte IN (1/*Pendiente*/, 4/*Parcial*/)
	AND CB.Id_Cond_Pago <> 1 	

	IF (@Cli_Ref_CtaCte_Agrup <> 0)    
	BEGIN
		UPDATE #Facturas_Pendientes 
		SET 
		Id_Cliente_Tit = Id_Cliente 
		WHERE 
		ISNULL(Id_Cliente_Tit,0) = 0  -- agrupa cta.cte completo el titular faltante
	END
	ELSE
	BEGIN
		UPDATE #Facturas_Pendientes 
		SET 
		Id_Cliente_Tit = Id_Cliente    --sino no agrupa reescribo el titular
	END

	UPDATE #Facturas_Pendientes 
	SET 
	Id_Cliente_Tit = Id_Cliente 
	WHERE 
	ISNULL(Id_Cliente_Tit,0) = 0
	
	/*-----------------------------------------------------------------------------------------------------------------------------------------------*/

	--Recorro #Recibos_Pendientes
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Recorre tabla #Recibos_Pendientes'
	END

	DECLARE CurCPJ_Cbtes_Aplic_Automat_Cli_RcVSFC CURSOR FOR 
	SELECT Id_Cliente_Tit, Id_Trans, Saldo
	FROM #Recibos_Pendientes 
	ORDER BY Id_Cliente_Tit, Id_Trans
        
	SET @ErrorNumber = 0

	OPEN CurCPJ_Cbtes_Aplic_Automat_Cli_RcVSFC
	FETCH NEXT FROM CurCPJ_Cbtes_Aplic_Automat_Cli_RcVSFC INTO @Id_Cliente, @Id_Trans_Rec, @Saldo_Rec
	WHILE @@FETCH_STATUS = 0 AND @ErrorNumber = 0
	BEGIN
		IF(@pModoDebug = 1)
		BEGIN
			PRINT '@Id_Cliente: ' + CONVERT(VARCHAR(10), @Id_Cliente) + '. @Id_Trans_Rec: ' + CONVERT(VARCHAR(10), @Id_Trans_Rec) + '. @Saldo_Rec: ' + CONVERT(VARCHAR(10), @Saldo_Rec)
			PRINT ' '
		END
		
		SELECT 
		@Email_Cob = ISNULL(Email_Cob, '')
		FROM Clientes
		WHERE
		Id_Cliente = @Id_Cliente

		--Recorro las #Facturas_Pendientes del cliente 
		IF(@pModoDebug = 1)
		BEGIN
			PRINT 'Recorro las #Facturas_Pendientes del Cliente'
		END

		DECLARE CurCPJ_Cbtes_Aplic_Automat_Cli_RcVSFC_Detalle CURSOR FOR 
		SELECT Id_Trans 
		FROM #Facturas_Pendientes 
		WHERE 
		Id_Cliente_Tit = @Id_Cliente 
		ORDER BY Id_Trans

		OPEN CurCPJ_Cbtes_Aplic_Automat_Cli_RcVSFC_Detalle
		FETCH NEXT FROM CurCPJ_Cbtes_Aplic_Automat_Cli_RcVSFC_Detalle INTO @Id_Trans_Fac	  
		WHILE @@FETCH_STATUS = 0 AND @ErrorNumber = 0
		BEGIN
			IF(@pModoDebug = 1)
			BEGIN
				PRINT '@Id_Trans_Fac: ' + CONVERT(VARCHAR(10), @Id_Trans_Fac)
			END

			/*Carga el saldo*/
			IF ISNULL(@pProvisorio,0) = 0
			BEGIN
				SET @Saldo_Fac = ISNULL((SELECT ISNULL(Saldo, 0) FROM Cbtes WHERE Id_Trans = @Id_Trans_Fac AND Id_Estado_Cbte IN (1/*Pendiente*/, 4/*Parcial*/)), 0)
			END
			ELSE
			BEGIN
				SET @Saldo_Fac = (SELECT ISNULL(Saldo, 0) FROM #Facturas_Pendientes WHERE Id_Trans = @Id_Trans_Fac)
			END

			IF(@pModoDebug = 1)
			BEGIN
				PRINT '@Saldo_Fac: $' + CONVERT(VARCHAR(10), @Saldo_Fac) + '. @Id_Trans_Fac: ' + CONVERT(VARCHAR(10), @Id_Trans_Fac)
			END

			IF(@pModoDebug = 1)
			BEGIN
				PRINT '@Saldo_Rec: $' + CONVERT(VARCHAR(10), @Saldo_Rec) + '. @Id_Trans_Rec: ' + CONVERT(VARCHAR(10), @Id_Trans_Rec)
			END

			IF (@Saldo_Rec > 0 AND @Saldo_Fac > 0)
			BEGIN
				IF (@Saldo_Rec = @Saldo_Fac)
				BEGIN
					IF(@pModoDebug = 1)
					BEGIN
						PRINT 'El Saldo del Recibo es igual al Saldo de la Factura.'
						PRINT ' '
					END

					SET @Saldo_Rec_A_Grabar = @Saldo_Rec
					SET @Importe =  @Saldo_Rec					

					INSERT INTO #Tab_Result 
					(Id_Cliente,		Id_Trans_Rec,		Saldo_Rec,
					Id_Trans_Fac,		Saldo_Fac,			Importe_Aplic)
					VALUES 
					(@Id_Cliente,		@Id_Trans_Rec,		@Saldo_Rec_A_Grabar,
					@Id_Trans_Fac,		@Saldo_Fac,			@Importe)
				END

				IF (@Saldo_Rec > @Saldo_Fac)
				BEGIN
					IF(@pModoDebug = 1)
					BEGIN
						PRINT 'El Saldo del Recibo es superior al Saldo de la Factura.'
						PRINT ' '
					END

					SET @Importe =  @Saldo_Fac
					SET @Saldo_Rec_A_Grabar = @Saldo_Rec

					INSERT INTO #Tab_Result 
					(Id_Cliente,		Id_Trans_Rec,		Saldo_Rec,
					Id_Trans_Fac,		Saldo_Fac,			Importe_Aplic)
					VALUES 
					(@Id_Cliente,		@Id_Trans_Rec,		@Saldo_Rec_A_Grabar,
					@Id_Trans_Fac,		@Saldo_Fac,			@Importe)
				END

				IF (@Saldo_Rec < @Saldo_Fac)
				BEGIN
					IF(@pModoDebug = 1)
					BEGIN
						PRINT 'El Saldo del Recibo es menor al Saldo de la Factura.'
						PRINT ' '
					END

					SET @Saldo_Rec_A_Grabar = @Saldo_Rec
					SET @Importe =  @Saldo_Rec

					INSERT INTO #Tab_Result 
					(Id_Cliente,		Id_Trans_Rec,		Saldo_Rec,
					Id_Trans_Fac,		Saldo_Fac,			Importe_Aplic)
					VALUES 
					(@Id_Cliente,		@Id_Trans_Rec,		@Saldo_Rec_A_Grabar,
					@Id_Trans_Fac,		@Saldo_Fac,			@Importe)
				END
				

				IF ISNULL(@pProvisorio,0) = 0
				BEGIN

					IF(@pModoDebug = 1)
					BEGIN
						PRINT 'Genera Recibo (Cbtes)'
					END

					DELETE @Respuesta
						
					SET @JSON_Parametros =	'{' +
											dbo.CF_Json_ParsearVariable('Id_Usuario', @pId_Usuario, 'INT') + ',' +
											dbo.CF_Json_ParsearVariable('Id_Cliente', @Id_Cliente, 'INT') + ',' +
											dbo.CF_Json_ParsearVariable('Email', @Email_Cob, 'VARCHAR') + ',' +
											dbo.CF_Json_ParsearVariable('Id_Periodo_Caja', @pId_Periodo_Caja, 'INT') + ',' +
											dbo.CF_Json_ParsearVariable('Fecha', @pFecha, 'DATETIME') + ',' +
											dbo.CF_Json_ParsearVariable('Importe', 0, 'DECIMAL') + ',' +
											dbo.CF_Json_ParsearVariable('Id_Tipo_Cbte', @pId_Tipo_Cbte_Rec_Nuevo, 'CHAR') + ',' +
											dbo.CF_Json_ParsearVariable('Id_Moneda', @pId_Moneda, 'CHAR') + ',' +
											dbo.CF_Json_ParsearVariable('Cotizacion', @pCotizacion, 'DECIMAL') + ',' +
											dbo.CF_Json_ParsearVariable('Lote', @pLote, 'VARCHAR') +
											'}'
		
					INSERT INTO @Respuesta			
					EXEC @UltError = CPJ_Cbtes_Rec_Generar @JSON_Parametros

					IF @UltError <> 0
					BEGIN
						IF ISNULL(@pFlagUsarTrans,0) <> 0 
						BEGIN
							ROLLBACK
						END

						SELECT * FROM @Respuesta	
						RETURN 4567
					END
					ELSE
					BEGIN
						SELECT TOP 1 @Id_Trans_Rec_Nuevo = ErrorLine FROM @Respuesta
					END

					IF(@pModoDebug = 1)
					BEGIN
						PRINT '@Id_Trans_Rec_Nuevo: ' + CONVERT(VARCHAR(10), @Id_Trans_Rec_Nuevo)
					END
					
					------------------------------------------------------------------------------------------------------------------------------------------------------------------

					IF(@pModoDebug = 1)
					BEGIN
						PRINT 'Genera Recibo (Cbtes_Items. Item Factura)'
					END

					DELETE @Respuesta
			
					SET @JSON_Parametros =	'{' +
											dbo.CF_Json_ParsearVariable('Id_Trans', @Id_Trans_Rec_Nuevo, 'INT') + ',' +
											dbo.CF_Json_ParsearVariable('Item', 1, 'SMALLINT') + ',' +
											dbo.CF_Json_ParsearVariable('Id_Producto', @pId_Producto_Devolucion, 'VARCHAR') + ',' +
											dbo.CF_Json_ParsearVariable('Cantidad', 1, 'DECIMAL') + ',' +
											dbo.CF_Json_ParsearVariable('Id_Trans_A_Cancelar', @Id_Trans_Fac, 'INT') + ',' +
											dbo.CF_Json_ParsearVariable('Importe_A_Cancelar', @Importe, 'DECIMAL') +
											'}'

					INSERT INTO @Respuesta
					EXEC @UltError = CPJ_Cbtes_Rec_Generar_Item @JSON_Parametros

					IF @UltError <> 0
					BEGIN
						IF ISNULL(@pFlagUsarTrans,0) <> 0 
						BEGIN
							ROLLBACK
						END

						SELECT * FROM @Respuesta
						RETURN 4569
					END
					
					------------------------------------------------------------------------------------------------------------------------------------------------------------------

					IF(@pModoDebug = 1)
					BEGIN
						PRINT 'Genera Recibo (Cbtes_Items. Item Recibo Orig)'
					END
					
					DELETE @Respuesta
			
					SET @Importe = @Importe * -1
					SET @JSON_Parametros =	'{' +
											dbo.CF_Json_ParsearVariable('Id_Trans', @Id_Trans_Rec_Nuevo, 'INT') + ',' +
											dbo.CF_Json_ParsearVariable('Item', 2, 'SMALLINT') + ',' +
											dbo.CF_Json_ParsearVariable('Id_Producto', @pId_Producto_Devolucion, 'VARCHAR') + ',' +
											dbo.CF_Json_ParsearVariable('Cantidad', 1, 'DECIMAL') + ',' +
											dbo.CF_Json_ParsearVariable('Id_Trans_A_Cancelar', @Id_Trans_Rec, 'INT') + ',' +
											dbo.CF_Json_ParsearVariable('Importe_A_Cancelar', @Importe, 'DECIMAL') +
											'}'

					INSERT INTO @Respuesta
					EXEC @UltError = CPJ_Cbtes_Rec_Generar_Item @JSON_Parametros

					IF @UltError <> 0
					BEGIN
						IF ISNULL(@pFlagUsarTrans,0) <> 0 
						BEGIN
							ROLLBACK
						END

						SELECT * FROM @Respuesta
						RETURN 4569
					END

					------------------------------------------------------------------------------------------------------------------------------------------------------------------

					IF(@pModoDebug = 1)
					BEGIN
						PRINT 'Genera Recibo (Fin)'
						PRINT ' '
					END


					DELETE @Respuesta
			
					SET @JSON_Parametros =	'{' +
											dbo.CF_Json_ParsearVariable('Id_Trans', @Id_Trans_Rec_Nuevo, 'INT') +
											'}'	
			
					INSERT INTO @Respuesta
					EXEC @UltError = CPJ_Cbtes_Rec_Fin @JSON_Parametros

					IF @UltError <> 0
					BEGIN
						IF ISNULL(@pFlagUsarTrans,0) <> 0 
						BEGIN
							ROLLBACK
						END

						SELECT * FROM @Respuesta	
						RETURN 4571
					END

					IF (@Saldo_Rec > @Saldo_Fac)
					BEGIN
						IF(@pModoDebug = 1)
						BEGIN
							PRINT 'El Saldo del Recibo es superior al Saldo de la Factura, el Saldo se pasa al recibo nuevo y el original queda completo con saldo cero para que se vea bien en Cta. Cte.'
							PRINT ' '
						END

						SET @Saldo_Rec_A_Grabar = @Saldo_Rec
						SET @Saldo_Rec_A_Grabar = @Saldo_Rec_A_Grabar - @Saldo_Fac

						--Recibo Original
						UPDATE Cbtes 
						SET
						Saldo = 0,
						Id_Estado_Cbte = 2
						WHERE
						Id_Trans = @Id_Trans_Rec

						UPDATE Clientes_CtaCte
						SET
						Saldo = 0,
						Id_Estado_Cbte = 2
						WHERE
						Id_Trans = @Id_Trans_Rec

						--Recibo Nuevo
						UPDATE Cbtes 
						SET
						Saldo = @Saldo_Rec_A_Grabar,
						Id_Estado_Cbte = 4
						WHERE
						Id_Trans = @Id_Trans_Rec_Nuevo

						UPDATE Clientes_CtaCte
						SET
						Saldo = (-1) * @Saldo_Rec_A_Grabar,
						Id_Estado_Cbte = 4
						WHERE
						Id_Trans = @Id_Trans_Rec_Nuevo
						AND Nro_Cuota = 1

					END
					------------------------------------------------------------------------------------------------------------------------------------------------------------------
				END
				ELSE
				BEGIN 
					/*Cuando es provisorio, se recalcula el saldo de la tabla temporal de facturas para el informe final*/
					IF(@pModoDebug = 1)
					BEGIN
						PRINT 'Se recalcula el saldo (@Saldo_Fac - @Importe) ' + CONVERT(VARCHAR(10), @Saldo_Fac - @Importe) + ' de la tabla temporal #Facturas_Pendientes de la @Id_Trans_Fac: ' + CONVERT(VARCHAR(10), @Id_Trans_Fac)
					END

					UPDATE #Facturas_Pendientes 
					SET 
					Saldo = @Saldo_Fac - @Importe
					WHERE 
					Id_Trans = @Id_Trans_Fac
				END				
        	END
			
			FETCH NEXT FROM CurCPJ_Cbtes_Aplic_Automat_Cli_RcVSFC_Detalle INTO @Id_Trans_FAC
		 END  
		 CLOSE CurCPJ_Cbtes_Aplic_Automat_Cli_RcVSFC_Detalle
		 DEALLOCATE CurCPJ_Cbtes_Aplic_Automat_Cli_RcVSFC_Detalle
		 --FIN Recorro las #Facturas_Pendientes del cliente 

		 FETCH NEXT FROM CurCPJ_Cbtes_Aplic_Automat_Cli_RcVSFC INTO @Id_Cliente, @Id_Trans_Rec, @Saldo_Rec
	END
	CLOSE CurCPJ_Cbtes_Aplic_Automat_Cli_RcVSFC
	DEALLOCATE CurCPJ_Cbtes_Aplic_Automat_Cli_RcVSFC
	--FIN Recorro #Recibos_Pendientes

	/*-----------------------------------------------------------------------------------------------------------------------------------------------*/

	IF ISNULL(@pProvisorio,0) = 0
	BEGIN
		UPDATE Cbtes_Lotes
		SET 
		Cantidad = (SELECT COUNT(*) FROM Cbtes WHERE Lote = @pLote),
		Importe = (SELECT SUM(Imp_total) FROM Cbtes WHERE Lote = @pLote),
		Fecha_Finalizacion = GETDATE()
		WHERE 
		Lote = @pLote
	END

	SELECT 
	T.*,
	CBRC.Fecha AS Fecha_NC, 
	CBFC.Fecha AS Fecha_Fac
	FROM #Tab_Result T, Cbtes CBRC, Cbtes CBFC
	WHERE 
	CBRC.Id_Trans = T.Id_Trans_Rec
	AND CBFC.Id_Trans = T.Id_Trans_Fac

	/*-----------------------------------------------------------------------------------------------------------------------------------------------*/

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Se eliminan las tablas temporales'
	END

	IF OBJECT_ID('tempdb..#Tab_Result') IS NOT NULL
	BEGIN
		DROP TABLE #Tab_Result
	END

	IF OBJECT_ID('tempdb..#Recibos_Pendientes') IS NOT NULL
	BEGIN
		DROP TABLE #Recibos_Pendientes
	END

	IF OBJECT_ID('tempdb..#Fac_Cli') IS NOT NULL
	BEGIN
		DROP TABLE #Fac_Cli
	END

	IF OBJECT_ID('tempdb..#Facturas_Pendientes') IS NOT NULL
	BEGIN
		DROP TABLE #Facturas_Pendientes
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'FIN Stored Procedure: CPJ_Cbtes_Aplic_Automat_Cli_RcVSFC'
		PRINT '---------------------------------------------------------------------------------------------------------------------'
	END


	/*-----------------------------------------------------------------------------------------------------------------------------------------------*/

	IF ISNULL(@pFlagUsarTrans,0) <> 0 
	BEGIN
		COMMIT
	END

	SET @rtaMsjStored = 'Finalizo CPJ_Cbtes_Aplic_Automat_Cli_RcVSFC'

	SELECT	 0				AS ErrorNumber 
			,0				AS ErrorSeverity  
			,0				AS ErrorState 
			,0				AS ErrorProcedure  
			,0				AS ErrorLine		
			,@rtaMsjStored	AS ErrorMessage

END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo; 

	IF ISNULL(@pFlagUsarTrans,0) <> 0 
	BEGIN
		ROLLBACK
	END

	RETURN 9999
END CATCH

RETURN 0

--EXEC CPJ_Cbtes_Aplic_Automat_Cli_RcVSFC '{"FlagUsarTrans":"0", "ModoDebug":"1", "Id_Usuario":"-1", "Id_Tipo_Cbte_Rec_A_Cta":"REC1", "Fecha":"20210115", "Id_Tipo_Cbte_Fac_Pend":"CUP", "Id_Tipo_Cbte_Rec_Nuevo":"REC1", "Id_Periodo_Caja":"7904", "Lote":"PRUEBA_APLIC", "Lote_Descrip":"Lote Aplicacion Prueba", "Id_Lote_Tipo":"2", "Id_Producto_Devolucion":"DEV", "Id_Moneda":"PES", "Cotizacion":"1", "Provisorio":"1"}'